// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for encrypting and decrypting the clipboard.
//........................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "Check.h"
#include "zlib.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;
extern	TCHAR				szFileToDecipher[MAX_PATH];
extern	TCHAR				szDestination[MAX_PATH];
extern	TCHAR				szFileToEncipher[MAX_PATH];
extern	HWND				hMainWindow;
extern	LPTSTR				lpszClipboard;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	BOOL				bProcessInProgress;
extern	LPBYTE				lpLineFeed;
extern	LPBYTE				lpSearchEDI;
extern	DWORD				dwProcedure;
extern	TCHAR				szTscFile[MAX_PATH];
extern	LARGE_INTEGER		liEncFileSize;
extern	BOOL				bUseMd5;
extern  LPBYTE				lpOutBuffer;
extern	DWORD				dwCheckCrc32;
extern	z_stream			z;
extern	MSG_HEADER			Msghdr;
extern	BYTE				MessageId[4];
extern	BOOL				bProgramRegistered;
extern	COLORREF			crBkgCurrent;
extern	COLORREF			crOleBkg;
extern	BOOL				bDecryptReadClip;
extern	UINT				uDecryptReadFormat;
extern	BOOL				bNoDecryptErr;
extern	DWORD				dwMyReplyFormat;
extern	BOOL				bIncludeBkgClr;
extern	BOOL				bExport;

// Determine the number of clipboard formats we can handle
// are available. 0 = RTF, 1 = HTML, 2 = Embed Source,
// 3 = Native, 4 = text, 5 = oemtext, 6 = unicodetext,
// and 7 = DIB.
//........................................................
DWORD	FormatsAvailable[8];

// Registered format numbers.
//...........................
DWORD	RegisteredFormats[] = {0, 0, 0, 0, CF_TEXT, CF_OEMTEXT, CF_UNICODETEXT, CF_DIB};

// Formating strings for the clipboard formats.
//.............................................
TCHAR	szRtf[] = "&Rich Text Format(%u)";
TCHAR	szHtml[] = "HTM&L Format(%u)";
TCHAR	szEmbed[] = "&Embed Source Format(%u)";
TCHAR	szNative[] = "&Native Format(%u)";
TCHAR	szText[] = "&Text Format(%u)";
TCHAR	szOem[] = "OE&M Text Format(%u)";
TCHAR	szUnicode[] = "&UniCode Text Format(%u)";
TCHAR	szDib[] = "&Device Independent Bitmap(%u)";

// Formated string table.
//.......................
LPCTSTR	lpStringTable[] = {(LPCTSTR)&szRtf, (LPCTSTR)&szHtml, (LPCTSTR)&szEmbed, 
						   (LPCTSTR)&szNative, (LPCTSTR)&szText,
						   (LPCTSTR)&szOem, (LPCTSTR)&szUnicode, (LPCTSTR)&szDib};

// Registered clipboard formats accepted.
//.......................................
UINT	uFormat;
UINT	uOurFormatUsed;

TCHAR	szClipboardTemp[] = "Clipboard.tmp";
TCHAR	szClipboardTsc[] = "Clipboard.tsc";

TCHAR	Header1[] = "-----BEGIN TSC ENCRYPTED MESSAGE-----\r\nVersion: Top Secret Crypto Gold v4.00 - For Private or Commercial Use - www.topsecretcrypto.com\r\nClipboard Format: %u\r\n\r\n";
TCHAR	Header1P[] = "-----BEGIN TSC ENCRYPTED MESSAGE-----\r\nVersion: Top Secret Crypto Gold v4.00 - For Personal Private Use Only - www.topsecretcrypto.com\r\nClipboard Format: %u\r\n\r\n";
TCHAR	Footer1[] = "-----END TSC ENCRYPTED MESSAGE-----\r\n";
TCHAR	szMessage3[] = "The contents of the clipboard was successfully encrypted. You can paste the encrypted data back into your application.";
TCHAR	szMessage4[] = "The contents of the clipboard was NOT successfully encrypted and placed back into the clipboard.";
TCHAR	szMessage5[] = "The contents of the clipboard was successfully decrypted. You can paste the decrypted data back into your application.";
TCHAR	szMessage6[] = "The contents of the clipboard was NOT successfully decrypted and placed back into the clipboard.";

// Encrypt the contents of the clipboard.
//.......................................
VOID EncryptTheClipboard()
{
	LARGE_INTEGER	li;
	LARGE_INTEGER	liPack;
	BOOL			bResult;
	BOOL			bClipOpen = FALSE;
	BOOL			bEncFile = FALSE;
	BOOL			bDeleteDest = FALSE;
	BOOL			bMem;
	BOOL			bError;
	BOOL			bInit = FALSE;
	DWORD			dwErrCode;
	UINT			uRealFormatUsed;
	DWORD			dwSize;
	DWORD			dwSize1;
	HANDLE			hClipboard;
	HGLOBAL			hGlobal;
	int				iTemp;
	int				i;
	int				iError;
	HANDLE			hFile = 0;
	HANDLE			hDestFile = 0;
	int				iDlgResult;
	DWORD			dwOldHelpTopic;
	DWORD			dwCurrentSize;
	DWORD			dwBytesWritten;
	DWORD			dwBytesRead;
	LPBYTE			lpClipboard = 0;
	LPBYTE			lpMyClipboard = 0;
	DWORD			OrderInClipboard = 0;
	DWORD			dwArmorLines;
	DWORD			dwMemNeeded;
	LPBYTE			lpEncryptedBuffer = 0;
	HGLOBAL			hClipboardMem;
	LPVOID			lpClipboardMem;
	LPBYTE			lpClipboardMemDup;
	OPENFILENAME	ofn;
	TCHAR			szBuffer[512];
	COLORREF		crSaveBkgColor;

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_ENCRYPTCLIPBOARD);

	// Put in a background color of white for all clipboard messages.
	//...............................................................
	crSaveBkgColor = crBkgCurrent;
	crBkgCurrent = 0xffffff;
	bIncludeBkgClr = TRUE;

	// Do not add the return receipt.
	//...............................
	bExport = TRUE;

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	ZeroMemory(&FormatsAvailable,sizeof(FormatsAvailable));

	bResult = OpenClipboard(hMainWindow);
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
		goto EncryptEnd;
	}
	bClipOpen = TRUE;

	// Get the formats that are available in the clipboard.
	//.....................................................
	uFormat = 0;
	while(TRUE)
	{
		uFormat = EnumClipboardFormats(uFormat);
		if (uFormat == 0 && OrderInClipboard == 0)
		{
			SetLastError(IDS_NOVALIDFORMATS);
			ErrorProcedure(lpszClipboard,IDS_ENUMCLIPFORMATS,MB_OK);
			goto EncryptEnd;
		}
		else if (uFormat == 0 && OrderInClipboard > 0)
		{
			break;
		}
		// Setup the number of formats and formats table.
		//...............................................
		for (i = 0; i < 8; i++)
		{
			if (uFormat == RegisteredFormats[i])
			{
				OrderInClipboard++;
				FormatsAvailable[i] = OrderInClipboard;
				break;
			}
		}
	}
	// Select the clipboard format to encrypt.
	//........................................
	uOurFormatUsed = -1;
	iDlgResult = DialogBox(hInst,TEXT("SELECTCLIPBOARDFORMAT"),hMainWindow,
						  (DLGPROC)SelectClipboardFormatProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto EncryptEnd;
	}
	// Quit if we canceled.
	//.....................
	if (iDlgResult == IDCANCEL)
	{
		goto EncryptEnd;
	}
	EmptyTheMessageQue();

	uRealFormatUsed = uOurFormatUsed;

	// Get the clipboard data.
	//........................
	hGlobal = GetClipboardData(uFormat);
	if (!hGlobal)
	{
		ErrorProcedure(lpszClipboard,IDS_GETCLIPBOARD,MB_OK);
		goto EncryptEnd;
	}
	lpMyClipboard = GlobalLock(hGlobal);
	if (!lpMyClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		goto EncryptEnd;
	}
	// Get the length of the clipboard so we can allocate our own memory block.
	//.........................................................................
	dwSize = (lstrlen((LPCTSTR)lpMyClipboard) + 1);

	lpClipboard = AllocateMemory(dwSize);

	// Transfer the contents to our own memory block.
	//...............................................
	lpClipboard = AllocateMemory(dwSize);
	if (!lpClipboard)
	{
		goto EncryptEnd;
	}
	dwCurrentSize = dwSize;
	CopyMemory(lpClipboard,lpMyClipboard,dwSize);
	GlobalUnlock(hGlobal);
	CloseClipboard();
	bClipOpen = FALSE;

	// Create a temporary file to be used by the encryption process.
	//..............................................................
	ZeroMemory(&szFileToEncipher,sizeof(szFileToEncipher));
	GetTempPath(MAX_PATH,(LPTSTR)&szFileToEncipher);
	StringCbCatEx((LPTSTR)&szFileToEncipher,sizeof(szFileToEncipher),
				  (LPCTSTR)&szClipboardTemp,NULL,NULL,dwStringSafeFlag);

	// If we are using the new protocol, compress the data.
	//.....................................................
	if (!bUseMd5)
	{
		// Setup the compressed message header.
		//.....................................
		CopyMemory(&Msghdr.MsgId,&MessageId,4);
		Msghdr.dwMsgSize = dwSize;

		// Do the crc32 for the file.
		//...........................
		Msghdr.dwMsgCrc32 = crc32(0L,Z_NULL,0);
		Msghdr.dwMsgCrc32 = crc32(Msghdr.dwMsgCrc32,lpClipboard,dwSize);

		// Setup the z_stream.
		//....................
		ZeroMemory(&z,sizeof(z));

		// Initialize the internal stream state for compression.
		//......................................................
		iError = deflateInit(&z,Z_BEST_COMPRESSION);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATEINIT);
			goto EncryptEnd;
		}
		bInit = TRUE;

		liPack.HighPart = 0;
		liPack.LowPart = deflateBound(&z,dwSize);

		// Allocate the memory.
		//.....................
		lpOutBuffer = AllocateMemory(liPack.LowPart);
		if (!lpOutBuffer)
		{
			goto EncryptEnd;
		}
		z.avail_in = dwSize;
		z.avail_out = liPack.LowPart;
		z.next_in = lpClipboard;
		z.next_out = lpOutBuffer;

		// Lets go and compress this message.
		//...................................
		iError = deflate(&z,Z_FINISH);
		if (iError < 0)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATE);
			goto EncryptEnd;
		}
		if (iError != Z_STREAM_END)
		{
			ZlibError((LPBYTE)&szFileToEncipher,Z_DATA_ERROR,IDS_DEFLATE);
			goto EncryptEnd;
		}
		iError = deflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATEEND);
			goto EncryptEnd;
		}
		bInit = FALSE;

		Msghdr.dwCompressedMsgSize = z.total_out;
	}
	// Create the file to encrypt.
	//............................
	hFile = CreateMyFile((LPTSTR)&szFileToEncipher,GENERIC_READ | GENERIC_WRITE,
						  0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFile)
	{
		goto EncryptEnd;
	}
	if (bUseMd5)
	{
		bResult = WriteMyFile((LPTSTR)&szFileToEncipher,hFile,lpClipboard,dwSize,
							   &dwBytesWritten,NULL);
	}
	else
	{
		// First the header.
		//..................
		bResult = WriteMyFile((LPTSTR)&szFileToEncipher,hFile,&Msghdr,sizeof(MSG_HEADER),
							   &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		// Write the compressed data.
		//...........................
		bResult = WriteMyFile((LPTSTR)&szFileToEncipher,hFile,lpOutBuffer,z.total_out,
							   &dwBytesWritten,NULL);
	}
	if (!bResult)
	{
		goto EncryptEnd;
	}
	// Get the size of the file.
	//..........................
	liEncFileSize.QuadPart = GetMyFileSize((LPTSTR)&szFileToEncipher,hFile);
	if (liEncFileSize.QuadPart == -1)
	{
		goto EncryptEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szFileToEncipher,hFile);
	if (!bResult)
	{
		goto EncryptEnd;
	}
	hFile = 0;
	bEncFile = TRUE;

	// Wipe and deallocate the memory for the buffers.
	//................................................
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,liPack.LowPart);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (lpClipboard)
	{
		ZeroMemory(lpClipboard,dwSize);
		DeallocateMemory(lpClipboard);
		lpClipboard = 0;
	}
	// Setup and call the encryption procedure.
	//.........................................
	bError = EncryptAFile((LPBYTE)&szFileToEncipher,&ofn);
	if (bError)
	{
		goto EncryptEnd;
	}
	// Now get the encrypted file into a buffer and transform
	// it for the clipboard.
	//.......................................................
	hDestFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ,0,NULL,
						      OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hDestFile)
	{
		goto EncryptEnd;
	}
	bDeleteDest = TRUE;

	li.QuadPart = GetMyFileSize((LPTSTR)&szDestination,hDestFile);
	if (li.QuadPart == -1)
	{
		goto EncryptEnd;
	}
	dwSize1 = li.LowPart;
	lpEncryptedBuffer = AllocateMemory(dwSize1);
	if (!lpEncryptedBuffer)
	{
		goto EncryptEnd;
	}
	bResult = ReadMyFile((LPTSTR)&szDestination,hDestFile,lpEncryptedBuffer,dwSize1,
					      &dwBytesRead,NULL);
	if (!bResult)
	{
		goto EncryptEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szDestination,hDestFile);
	if (!bResult)
	{
		goto EncryptEnd;
	}
	hDestFile = 0;

	// Figure out the memory needed for the armor buffer.
	//...................................................
	__asm
	{
		xor		edx,edx
		mov		eax,dwSize1
		mov		ecx,48
		div		ecx
		cmp		edx,0
		je		L1
		inc		eax
	L1:	mov		dwArmorLines,eax
	}
	dwMemNeeded = ((dwArmorLines * 66) + 1024);
	dwCurrentSize = dwMemNeeded;
	hClipboardMem = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,dwMemNeeded);
	if (hClipboardMem == NULL)
	{
		ErrorProcedure((LPTSTR)lpszClipboard,IDS_ALLOCATEMEMORY,MB_OK);
		goto EncryptEnd;
	}
	lpClipboardMem = GlobalLock(hClipboardMem);
	if (lpClipboardMem == NULL)
	{
		ErrorProcedure((LPTSTR)lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		GlobalFree(hClipboardMem);
		goto EncryptEnd;
	}
	ZeroMemory(lpClipboardMem,dwMemNeeded);

	// Put in the header.
	//...................
	lpClipboardMemDup = lpClipboardMem;
	ZeroMemory(&szBuffer,sizeof(szBuffer));
	if (bProgramRegistered)
	{
		StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&Header1,uRealFormatUsed);
	}
	else
	{
		StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&Header1P,uRealFormatUsed);
	}
	CopyMemory(lpClipboardMemDup,&szBuffer,lstrlen((LPCTSTR)&szBuffer));
	iTemp = lstrlen((LPCTSTR)&szBuffer);
	__asm
	{
		mov		ecx,iTemp
		mov		edi,lpClipboardMemDup
		add		edi,ecx
		mov		lpClipboardMemDup,edi
	}
	// Armor the buffer.
	//..................
	lpClipboardMemDup = ArmorBuffer(lpEncryptedBuffer,lpClipboardMemDup,dwSize1);

	// Put in the footer.
	//...................
	CopyMemory(lpClipboardMemDup,&Footer1,lstrlen((LPCTSTR)&Footer1));

	// Unlock the memory for the clipboard.
	//.....................................
	bMem = GlobalUnlock(hClipboardMem);
	if (!bMem)
	{
		dwErrCode = GetLastError();
		if (dwErrCode != NO_ERROR)
		{
			SetLastError(dwErrCode);
			ErrorProcedure(lpszClipboard,IDS_UNLOCKMEMORY,MB_OK);
			goto EncryptEnd;
		}
	}
	// Open the Clipboard.
	//....................
	bResult = OpenClipboard(hMainWindow);
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
		goto EncryptEnd;
	}
	bClipOpen = TRUE;

	bResult = EmptyClipboard();
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_EMPTYCLIPBOARD,MB_OK);
		goto EncryptEnd;
	}
	hClipboard = SetClipboardData(CF_TEXT,hClipboardMem);
	if (!hClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_SETCLIPBOARD,MB_OK);
		goto EncryptEnd;
	}
	bResult = CloseClipboard();

	ZeroMemory(&szBuffer,sizeof(szBuffer));

	if (bResult)
	{
		CopyMemory(&szBuffer,&szMessage3,sizeof(szMessage3));
		bClipOpen = FALSE;
		lpClipboard = 0;
	}
	else
	{
		CopyMemory(&szBuffer,&szMessage4,sizeof(szMessage4));
	}
	MessageBoxProc(hMainWindow,IDS_CLOSECLIPBOARD,(UINT)&szBuffer,
				   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);

	EncryptEnd:

	if (bInit)
	{
		iError = deflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATEEND);
			bResult = FALSE;
		}
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,liPack.LowPart);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	// Close the clipboard.
	//.....................
	if (bClipOpen)
	{
		CloseClipboard();
	}
	if (lpClipboard)
	{
		ZeroMemory(lpClipboard,dwSize);
		DeallocateMemory(lpClipboard);
	}
	if (hFile)
	{
		CloseMyHandle((LPTSTR)&szFileToEncipher,hFile);
	}
	if (bEncFile)
	{
		WipeMyFile((LPTSTR)&szFileToEncipher,TRUE);
	}
	if (hDestFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hDestFile);
	}
	if (bDeleteDest)
	{
		WipeMyFile((LPTSTR)&szDestination,TRUE);
	}
	if (lpEncryptedBuffer)
	{
		ZeroMemory(lpEncryptedBuffer,dwSize1);
		DeallocateMemory(lpEncryptedBuffer);
	}
	// Reset some values.
	//...................
	crBkgCurrent = crSaveBkgColor;
	bIncludeBkgClr = FALSE;
	bExport = FALSE;

	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// Select the type of clipboard format to encrypt.
//................................................
LRESULT CALLBACK SelectClipboardFormatProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			TCHAR		szBuffer[128];
			int			i;

			// Setup the commands for the dialog box.
			//.......................................
			for (i = 0; i < 8; i++)
			{
				StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),lpStringTable[i],
								FormatsAvailable[i]);
				SetDlgItemText(hDlg,IDC_RTF + i,(LPCTSTR)&szBuffer);

				if (FormatsAvailable[i] == 0)
				{
					EnableWindow(GetDlgItem(hDlg,IDC_RTF + i),FALSE);
				}
				else if (uOurFormatUsed == -1)
				{
					uOurFormatUsed = i;
				}
			}
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_RTF:
				{
					CheckRadioButton(hDlg,IDC_RTF,IDC_DIB,IDC_RTF);
					uOurFormatUsed = 0;
				}
				break;

				case IDC_HTML:
				{
					CheckRadioButton(hDlg,IDC_RTF,IDC_DIB,IDC_HTML);
					uOurFormatUsed = 1;
				}
				break;

				case IDC_ES:
				{
					CheckRadioButton(hDlg,IDC_RTF,IDC_DIB,IDC_ES);
					uOurFormatUsed = 2;
				}
				break;

				case IDC_NATIVE:
				{
					CheckRadioButton(hDlg,IDC_RTF,IDC_DIB,IDC_NATIVE);
					uOurFormatUsed = 3;
				}
				break;

				case IDC_TEXT:
				{
					CheckRadioButton(hDlg,IDC_RTF,IDC_DIB,IDC_TEXT);
					uOurFormatUsed = 4;
				}
				break;

				case IDC_OEM:
				{
					CheckRadioButton(hDlg,IDC_RTF,IDC_DIB,IDC_OEM);
					uOurFormatUsed = 5;
				}
				break;

				case IDC_UNICODE:
				{
					CheckRadioButton(hDlg,IDC_RTF,IDC_DIB,IDC_UNICODE);
					uOurFormatUsed = 6;
				}
				break;

				case IDC_DIB:
				{
					CheckRadioButton(hDlg,IDC_RTF,IDC_DIB,IDC_DIB);
					uOurFormatUsed = 7;
				}
				break;

				case IDOK:
				{
					UINT		i;

					for (i = 0; i < 8; i++)
					{
						if (uOurFormatUsed == i)
						{
							uFormat = RegisteredFormats[i];
							break;
						}
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Decrypt the contents of the clipboard.
//.......................................
VOID DecryptTheClipboard()
{
	LARGE_INTEGER	li;
	BOOL			bResult;
	LPBYTE			lpTemp;
	HGLOBAL			hGlobal;
	DWORD			dwCrc24Dup;
	DWORD			dwCrc24;
	LPBYTE			lpClipboard;
	DWORD			dwLength;
	DWORD			dwSearchLength;
	DWORD			dwTemp = 0;
	DWORD			dwKeyLength;
	DWORD			dwBytesWritten;
	DWORD			dwBytesRead;
	DWORD			dwCurrentSize;
	DWORD			dwErrCode;
	HANDLE			hClipboardMem;
	HANDLE			hClipboard;
	DWORD			dwOldHelpTopic;
	DWORD			dwSize;
	BOOL			bMem;
	BOOL			bInit = FALSE;
	BOOL			bClipOpen = FALSE;
	int				i;
	int				iError;
	int				iCompareResult;
	LPMSG_HEADER	lpMsgHdr;
	LPBYTE			lpDecompBuffer = 0;
	HANDLE			hDecompBuffer;
	LPBYTE			lpSource;
	UINT			uFormat = 0;
	LPBYTE			lpMyClipboard = 0;
	LPBYTE			lpDestination = 0;
	LPBYTE			lpClipboardMem = 0;
	HANDLE			hFile = 0;
	HANDLE			hDestFile = 0;
	BOOL			bTscFile = FALSE;
	BOOL			bDeleteDest = FALSE;
	BOOL			bError;
	TCHAR			szBuffer[512];

	if (!bDecryptReadClip)
	{
		bProcessInProgress = TRUE;
		if (dwProcedure == IDM_DECRYPT)
		{
			dwOldHelpTopic = ChangeHelpTopic(IDH_DECRYPTCLIPBOARD);
		}
		else
		{
			dwOldHelpTopic = ChangeHelpTopic(IDH_VIEWENCCONTENTS);
		}
	}
	lpTemp = (LPBYTE)&dwCrc24Dup;

	GetClipboardFormatNumbers();

	bResult = OpenClipboard(hMainWindow);
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
		goto DecryptEnd;
	}
	bClipOpen = TRUE;

	while(TRUE)
	{
		uFormat = EnumClipboardFormats(uFormat);
		if (uFormat == 0)
		{
			if (GetLastError() != NO_ERROR)
			{
				ErrorProcedure(lpszClipboard,IDS_ENUMCLIPFORMATS,MB_OK);
				goto DecryptEnd;
			}
			else
			{
				SetLastError(IDS_NOTEXTFORMAT);
				ErrorProcedure(lpszClipboard,IDS_ENUMCLIPFORMATS,MB_OK);
				goto DecryptEnd;
			}
		}
		if (uFormat == CF_TEXT)
		{
			break;
		}
	}
	// We have a text format to get, so do it.
	//........................................
	hGlobal = GetClipboardData(uFormat);
	if (!hGlobal)
	{
		ErrorProcedure(lpszClipboard,IDS_GETCLIPBOARD,MB_OK);
		goto DecryptEnd;
	}
	lpClipboard = GlobalLock(hGlobal);
	if (!lpClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		goto DecryptEnd;
	}
	// Get the length of the clipboard so we can allocate our own memory block.
	//.........................................................................
	dwLength = (lstrlen((LPCTSTR)lpClipboard) + 1);

	lpMyClipboard = AllocateMemory(dwLength);
	if (!lpMyClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		goto DecryptEnd;
	}
	// Copy the clipboard to our memory block.
	//........................................
	CopyMemory(lpMyClipboard,lpClipboard,dwLength);

	GlobalUnlock(hGlobal);

	// Close the clipboard.
	//.....................
	bResult = CloseClipboard();
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_CLOSECLIPBOARD,MB_OK);
	}
	lpClipboard = 0;
	bClipOpen = FALSE;
	dwSearchLength = dwLength;

	// Scan for at least 6 line feed characters in the message.
	//.........................................................
	__asm
	{
		mov		ecx,dwSearchLength
		mov		esi,lpMyClipboard
	L1:	lodsb
		cmp		al,0x00
		je		L3
		cmp		al,0x0a
		jne		L2
		inc		dwTemp
	L2:	dec		ecx
		jnz		L1
	}
	L3:

	if (dwTemp < 6)
	{
	  NoMsgError:
		SetLastError(IDS_NOENCRYPTEMSG);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto DecryptEnd;
	}
	// Check for the trailing header to make sure we incorporated the whole message.
	//..............................................................................
	bResult = SearchFor((LPBYTE)&Footer1,35,(LPBYTE)lpMyClipboard,dwSearchLength);
	if (!bResult)
	{
		goto NoMsgError;
	}
	// Check the header to  see if we have a valid tsc encrypted message.
	//...................................................................
	bResult = SearchFor((LPBYTE)&Header1,37,(LPBYTE)lpMyClipboard,dwSearchLength);
	if (!bResult)
	{
		goto NoMsgError;
	}
	// Now get past the next two line feed characters. 
	//................................................
	lpClipboard = lpSearchEDI;
	dwSearchLength = (dwLength + lpMyClipboard - lpClipboard);
	
	for (i = 0; i < 2; i++)
	{
		bResult = SearchFor(lpLineFeed,1,lpClipboard,dwSearchLength);
		if (!bResult)
		{
			goto NoMsgError;
		}
		lpClipboard = lpSearchEDI;
		lpClipboard++;
		dwSearchLength = (dwLength + lpMyClipboard - lpClipboard);
	}
	// The next phrase should be the clipboard format.
	//................................................
	bResult = SearchFor(&Header1[136],18,lpClipboard,dwSearchLength);
	if (!bResult)
	{
		goto NoMsgError;
	}
	lpClipboard = lpSearchEDI;
	dwSearchLength = (dwLength + lpMyClipboard - lpClipboard);
	
	// Get the next byte of data which is our clipboard format.
	//.........................................................
	__asm
	{
		mov		edi,lpClipboard
		add		edi,18
		movzx	eax,byte ptr [edi]
		and		eax,0x0f
		mov		uFormat,eax
		mov		dwMyReplyFormat,eax
	}
	// Setup the actual number of the clipboard format.
	//.................................................
	uFormat = RegisteredFormats[uFormat];

	// Now we have to get past the format line and find the start of the message.
	// Search for line feeds with a first character of 'q' following.
	//...........................................................................
	i = 5;
	while(i > 0)
	{
		bResult = SearchFor(lpLineFeed,1,lpClipboard,dwSearchLength);
		if (!bResult)
		{
			goto NoMsgError;
		}
		lpClipboard = lpSearchEDI;
		lpClipboard++;
		if (*lpClipboard == 'h')
		{
			break;
		}
		dwSearchLength = (dwLength + lpMyClipboard - lpClipboard);
		i--;
	}
	if (*lpClipboard != 'h')
	{
		goto NoMsgError;
	}
	// lpClipboard points to the start of the encrypted message.
	// Decode the block to get our encrypted message and crc24 value.
	//...............................................................
	lpDestination = AllocateMemory(dwLength + 4096);
	if (!lpDestination)
	{
		ErrorProcedure(lpszNA,IDS_ALLOCATEMEMORY,MB_OK);
		goto DecryptEnd;
	}
	dwCurrentSize = dwLength + 4096;
	dwCrc24 = CRC24_INIT;

	// Dearmor the buffer.
	//....................
	lpClipboard = DearmorBuffer(lpClipboard,lpDestination,&dwKeyLength);
	if (lpClipboard == 0)
	{
		SetLastError(IDS_DEARMORBUFFERERROR);
		ErrorProcedure(lpszClipboard,IDS_READ,MB_OK);
		goto DecryptEnd;
	}
	// We are finished with the conversion.
	// Calculate the crc24 value.
	//.....................................
	dwCrc24 = Crc24Update(dwCrc24,lpDestination,dwKeyLength);

	// Backup the pointer 2 spaces so we can search for a \n.
	//.......................................................
	lpClipboard--;
	lpClipboard--;

	// Now retrieve the crc24 value from the clipboard buffer.
	// lpClipboard points to the = after the key and before
	// the crc24 value. Could be more than one.
	//........................................................
	bResult = SearchFor(lpLineFeed,1,lpClipboard,10);
	if (!bResult)
	{
	  NoValidCrc:
		SetLastError(IDS_NOVALIDCRC24);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto DecryptEnd;
	}
	lpClipboard = lpSearchEDI;
	lpClipboard++;
	if (*lpClipboard != '=')
	{
		goto NoValidCrc;
	}
	lpClipboard++;

	dwCrc24Dup = GetCrc24(lpClipboard);

	if (dwCrc24 != dwCrc24Dup)
	{
		SetLastError(IDS_CRC24NOMATCH);
		ErrorProcedure(lpszClipboard,IDS_COMPARE,MB_OK);
		goto DecryptEnd;
	}
	// See if we have a background color to get. First get the standard window color
	// in case there is not one. This is for decrypting an e-mail message in the
	// clipboard and reading it in a rtf window.
	//..............................................................................
	crBkgCurrent = GetSysColor(COLOR_WINDOW);
	lpClipboard += 4;
	if (*lpClipboard == '=')
	{
		lpClipboard++;
		crBkgCurrent = GetCrc24(lpClipboard);
		crOleBkg = crBkgCurrent;
	}
	// Deallocate the memory for the clipboard buffer.
	//................................................
	ZeroMemory(lpMyClipboard,dwLength);
	DeallocateMemory(lpMyClipboard);
	lpMyClipboard = 0;

	// We have the encrypted contents of the clipboard. Create a tsc
	// file to place the contents in.
	//..............................................................
	ZeroMemory(&szFileToDecipher,MAX_PATH);
	ZeroMemory(&szDestination,MAX_PATH);
	GetTempPath(MAX_PATH,(LPTSTR)&szFileToDecipher);
	GetTempPath(MAX_PATH,(LPTSTR)&szDestination);
	StringCbCatEx((LPTSTR)&szFileToDecipher,sizeof(szFileToDecipher),
				  (LPCTSTR)&szClipboardTsc,NULL,NULL,dwStringSafeFlag);

	hFile = CreateMyFile((LPTSTR)&szFileToDecipher,GENERIC_READ | GENERIC_WRITE,
						  0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFile)
	{
		goto DecryptEnd;
	}
	bResult = WriteMyFile((LPTSTR)&szFileToDecipher,hFile,lpDestination,dwKeyLength,
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto DecryptEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szFileToDecipher,hFile);
	if (!bResult)
	{
		goto DecryptEnd;
	}
	hFile = 0;
	bTscFile = TRUE;

	// Check out the file. It has to be a valid tsc encrypted file.
	// It may be possible to get a corrupted encypted clipboard.
	//.............................................................
	li.QuadPart = IsTscFileValid((LPBYTE)&szFileToDecipher);

	if (li.QuadPart == -1)
	{
		SetLastError(IDS_NOTVALIDTSCFILE);
		ErrorProcedure((LPTSTR)&szFileToDecipher,IDS_CREATE_OPEN,MB_OK);
		goto DecryptEnd;
	}
	ZeroMemory(lpDestination,dwCurrentSize);
	DeallocateMemory(lpDestination);
	lpDestination = 0;

	// If we are just viewing the contents of the encrypted clipboard
	// call the view tsc file procedure.
	//...............................................................
	if (dwProcedure == IDM_VIEWENCCONTENTS)
	{
		CopyMemory(&szTscFile,&szFileToDecipher,MAX_PATH);
		ViewTscFile();
	}
	else
	{
		// Setup and call the decryption procedure.
		//.........................................
		bError = DecryptAFile((LPBYTE)&szFileToDecipher);
		if (bError)
		{
			goto DecryptEnd;
		}
		// Now get the decrypted file into a buffer and transform
		// it for the clipboard.
		//.......................................................
		hDestFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ,0,NULL,
								  OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hDestFile)
		{
			goto DecryptEnd;
		}
		bDeleteDest = TRUE;

		li.QuadPart = GetMyFileSize((LPTSTR)&szDestination,hDestFile);
		if (li.QuadPart == -1)
		{
			goto DecryptEnd;
		}
		dwSize = li.LowPart;

		// Allocate the memory to place the clipboard data into.
		//......................................................
		hClipboardMem = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,dwSize);
		if (hClipboardMem == NULL)
		{
			ErrorProcedure((LPTSTR)lpszClipboard,IDS_ALLOCATEMEMORY,MB_OK);
			goto DecryptEnd;
		}
		lpClipboardMem = GlobalLock(hClipboardMem);
		if (lpClipboardMem == NULL)
		{
			ErrorProcedure((LPTSTR)lpszClipboard,IDS_LOCKMEMORY,MB_OK);
			GlobalFree(hClipboardMem);
			goto DecryptEnd;
		}
		ZeroMemory(lpClipboardMem,dwSize);

		// Read the data from the file into the clipboard buffer.
		//.......................................................
		bResult = ReadMyFile((LPTSTR)&szDestination,hDestFile,lpClipboardMem,dwSize,
							  &dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecryptEnd;
		}
		bResult = CloseMyHandle((LPTSTR)&szDestination,hDestFile);
		if (!bResult)
		{
			goto DecryptEnd;
		}
		hDestFile = 0;

		lpMsgHdr = (LPMSG_HEADER)lpClipboardMem;

		// See if we have compressed data the must be decompressed.
		//.........................................................
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&MessageId,4,
									  (LPCTSTR)lpMsgHdr->MsgId,4);
		if (iCompareResult == CSTR_EQUAL)
		{
			// We have to decompress the data.
			//................................
			hDecompBuffer = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,lpMsgHdr->dwMsgSize);
			if (hDecompBuffer == NULL)
			{
				ErrorProcedure((LPTSTR)lpszClipboard,IDS_ALLOCATEMEMORY,MB_OK);
				goto DecryptEnd;
			}
			lpDecompBuffer = GlobalLock(hDecompBuffer);
			if (lpDecompBuffer == NULL)
			{
				ErrorProcedure((LPTSTR)lpszClipboard,IDS_LOCKMEMORY,MB_OK);
				GlobalFree(hClipboardMem);
				goto DecryptEnd;
			}
			// Setup to decompress the data.
			//..............................
			ZeroMemory(&z,sizeof(z_stream));

			dwCheckCrc32 = crc32(0L,Z_NULL,0);
			lpSource = lpClipboardMem;
			lpSource += sizeof(MSG_HEADER);

			z.next_in = lpSource;
			z.next_out = lpDecompBuffer;
			z.avail_in = lpMsgHdr->dwCompressedMsgSize;
			z.avail_out = lpMsgHdr->dwMsgSize;

			iError = inflateInit(&z);
			if (iError != Z_OK)
			{
				ZlibError((LPBYTE)&szDestination,iError,IDS_INFLATEINIT);
				goto DecryptEnd;
			}
			bInit = TRUE;

			iError = inflate(&z,Z_FINISH);
			if (iError < 0)
			{
				ZlibError((LPBYTE)&szDestination,iError,IDS_INFLATE);
				goto DecryptEnd;
			}
			if (iError != Z_STREAM_END)
			{
				ZlibError((LPBYTE)&szDestination,Z_DATA_ERROR,IDS_INFLATE);
				goto DecryptEnd;
			}
			// Get the final crc32 check value.
			//.................................
			dwCheckCrc32 = crc32(dwCheckCrc32,lpDecompBuffer,z.total_out);

			if (dwCheckCrc32 != lpMsgHdr->dwMsgCrc32)
			{
				SetLastError(IDS_EMAILCRCNOGOOD);
				ErrorProcedure((LPTSTR)&szDestination,IDS_COMPARE,MB_OK);
				goto DecryptEnd;
			}
			iError = inflateEnd(&z);
			if (iError != Z_OK)
			{
				ZlibError((LPBYTE)&szDestination,iError,IDS_INFLATEEND);
				goto DecryptEnd;
			}
			bInit = FALSE;

			// We have to wipe the original buffer.
			//.....................................
			ZeroMemory(lpClipboardMem,dwSize);
			GlobalUnlock(hClipboardMem);
			GlobalFree(hClipboardMem);

			hClipboardMem = hDecompBuffer;
			lpClipboardMem = lpDecompBuffer;
		}
		// Unlock the memory for the clipboard.
		//.....................................
		bMem = GlobalUnlock(hClipboardMem);
		if (!bMem)
		{
			dwErrCode = GetLastError();
			if (dwErrCode != NO_ERROR)
			{
				SetLastError(dwErrCode);
				ErrorProcedure(lpszClipboard,IDS_UNLOCKMEMORY,MB_OK);
				goto DecryptEnd;
			}
		}
		// Lets put the data back onto the clipboard in its original format.
		//..................................................................
		bResult = OpenClipboard(hMainWindow);
		if (!bResult)
		{
			ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
			goto DecryptEnd;
		}
		bClipOpen = TRUE;

		bResult = EmptyClipboard();
		if (!bResult)
		{
			ErrorProcedure(lpszClipboard,IDS_EMPTYCLIPBOARD,MB_OK);
			goto DecryptEnd;
		}
		hClipboard = SetClipboardData(uFormat,hClipboardMem);
		if (!hClipboard)
		{
			ErrorProcedure(lpszClipboard,IDS_SETCLIPBOARD,MB_OK);
			goto DecryptEnd;
		}
		// Store the format for decrypting and reading the message.
		//.........................................................
		uDecryptReadFormat = uFormat;

		bResult = CloseClipboard();

		bNoDecryptErr = bResult;

		if (bResult)
		{
			CopyMemory(&szBuffer,&szMessage5,sizeof(szMessage5));
			bClipOpen = FALSE;
			lpClipboardMem = 0;
		}
		else
		{
			CopyMemory(&szBuffer,&szMessage6,sizeof(szMessage6));
		}
		if (!bDecryptReadClip)
		{
			MessageBoxProc(hMainWindow,IDS_CLOSECLIPBOARD,(UINT)&szBuffer,
						   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);
		}
	}

	DecryptEnd:

	if (bInit)
	{
		iError = inflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szDestination,iError,IDS_INFLATEEND);
		}
	}
	if (bClipOpen)
	{
		CloseClipboard();
	}
	if (lpMyClipboard)
	{
		ZeroMemory(lpMyClipboard,dwLength);
		DeallocateMemory(lpMyClipboard);
	}
	if (lpClipboardMem)
	{
		ZeroMemory(lpClipboardMem,dwSize);
		DeallocateMemory(lpClipboardMem);
	}
	if (lpDestination)
	{
		ZeroMemory(lpDestination,dwCurrentSize);
		DeallocateMemory(lpDestination);
	}
	if (hFile)
	{
		CloseMyHandle((LPTSTR)&szFileToDecipher,hFile);
	}
	if (bTscFile)
	{
		WipeMyFile((LPBYTE)&szFileToDecipher,TRUE);
	}
	if (hDestFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hDestFile);
	}
	if (bDeleteDest)
	{
		WipeMyFile((LPBYTE)&szDestination,TRUE);
	}
	if (!bDecryptReadClip)
	{
		ChangeHelpTopic(dwOldHelpTopic);
		bProcessInProgress = FALSE;
	}
}

// Get the registered clipboard format numbers.
//.............................................
VOID GetClipboardFormatNumbers()
{
	RegisteredFormats[CF_HTML1] = RegisterClipboardFormat("HTML Format");
	RegisteredFormats[CF_RTF1] = RegisterClipboardFormat("Rich Text Format");
	RegisteredFormats[CF_ES1] = RegisterClipboardFormat("Embed Source");
	RegisteredFormats[CF_NATIVE1] = RegisterClipboardFormat("Native");
}
